clear all;
close all;
clc;

% ABS design via sliding mode-based ESC
% define the global variable
global mustar lambdastar c k a m B R I
global usave tsave

uxsave=[]; uysave=[]; tsave=[];

%Nonlinear map parameters
mustar=0.6;
lambdastar=0.25;
k=1;
a=0.1;
c=20;
m=400;
B=0.01;
R=0.3;
I=m*R*R;

% simulation
t0=0;  % start time
t1=6;  % end time

%initial condition of the state 
x0=[33.33,400/3.6,0.1];   

% solving the ode
tspan=[t0 t1];  
[t,x]=ode23('abs_slidingmode_derivatives',tspan,x0);    
    
for i=1:length(t)
    idx = find(tsave-t(i)==0);
    u(i)=usave(idx(length(idx)));
end;

% trajectory of the states
v=x(:,1);
omega=x(:,2);
lambda0=x(:,3);
lambda=(v-R.*omega)./v;

J=2.*mustar.*lambdastar.*lambda./(lambdastar.^2+lambda.^2);

figure 
plot(t,J,'r','LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('output','FontSize',18,'FontWeight','bold');
title('Friction Force Coeffient','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
%saveas(gcf,'abs_output_smesc.eps','psc2');



figure 
plot(t,lambda,'r','LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('\lambda','FontSize',18,'FontWeight','bold');
title('Slip','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
%saveas(gcf,'abs_lambda_smesc.eps','psc2');


figure 
plot(t,v,t,omega,'r','LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('x','FontSize',18,'FontWeight','bold');
title('Linear Velocity and Angular Velocity','FontSize',18,'FontWeight','bold');
grid on;  
legend('Linear Velocity','Angular Velocity');
set(gca,'FontSize',12,'FontWeight','bold'); 
%saveas(gcf,'abs_state_smesc.eps','psc2');


figure 
plot(t,u,'r','LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('u','FontSize',18,'FontWeight','bold');
title('Braking Torque','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
%saveas(gcf,'abs_control_smesc.eps','psc2');